/*****************************************************/
/* Examples Program For "ET-ARM7 BASE LPC2103" Board */
/* Target MCU  : Philips ARM7-LPC2103                */
/*       	   : X-TAL : 19.6608 MHz                 */
/*             : Run Speed 58.9824MHz (With PLL)     */
/* Keil Editor : uVision3 V3.03a                     */
/* Compiler    : Keil CARM V2.50a		             */
/* Create By   : Eakachai Makarn (WWW.ETT.CO.TH)     */
/* Last Update : 17/April/2006                       */
/* Function    : Example Use I2C Interface (PCF8574) */
/*             : LED Moving on Output of PCF8574     */	
/*****************************************************/
// LPC2103 GPIO0.2  = SCL-0
// LPC2103 GPIO0.3  = SDA-0
// I2C Device       = PCF8574A
// Slave ID         = 0x70 --> [0111(ID)+000(Addr)+0(W)]
// PCF8574A Address = 0x00 --> [A2,A1,A0 : 000]

/* Warning Pull-Up 10K on I2C Pin
    -> Pin GPIO0.2 (SCL)
    -> Pin GPIO0.3 (SDA)    
   PCF8754/A Not Stable(Not Work) if Not Pull-Up
*/

#include <LPC2103.H> 	                                	// LPC2103 MPU Register

/* pototype  section */
void write_PCF8574(unsigned char ,unsigned char);			// Write Output PCF8574A
void delay_led(unsigned long int);							// Delay Time Function

// Start Main Program Here //
int main(void)
{
  unsigned char LED; 										// LED Output Status Buffer
    
  // Initial GPIO0.2 = SCL
  // Initial GPIO0.3 = SDA  
  PINSEL0 &= 0xFFFFFF0F;									// Reset GPIO0[3:2] Status
  PINSEL0 |= 0x00000010;									// GPIO0.2 = SCL
  PINSEL0 |= 0x00000040;									// GPIO0.3 = SDA

  // Initial I2C Data Rate = 100KHz(VPB=29.4912MHz)
  // I2C Data Rate = 29.4912MHz / 294
  //               = 100.31KHz
  I2C0SCLH = 0x00000093;									// Clock High = 147
  I2C0SCLL = 0x00000093;									// Clock Low  = 147

  // Start Loop Test Output PCF8574A //
  while(1)													// Loop Continue
  {
    for(;;)
    { 
      for (LED = 0x01; LED < 0x80; LED <<= 1)				// Shift Left GPIO-0 (Right <- Left)
      { 
	    write_PCF8574(0x70,0xFF-LED);						// Send I2C = PCF8574A+Write(0111000+W),LED(Toggle Logic Drive)				
        delay_led(5000000);	    							// Display Delay	    			
      }								 

      for (LED = 0x80; LED > 0x01; LED >>= 1)				// Shift Right GPIO-0(Right -> Left)
      { 
	    write_PCF8574(0x70,0xFF-LED);						// Send I2C = PCF8574A+Write(0111000+W),LED	(Toggle Logic Drive)
        delay_led(5000000);	    							// Display Delay		
      }  
	    
	} 
  }   	
}  

/*********************************/
/* Write Output Data to PCF8574A */
/* Addr = ID Code+Direction(W:0) */
/* Data = Output Data Write Port */
/*********************************/
void write_PCF8574(unsigned char Addr,unsigned char Data)	// Write Output PCF8574A
{
  I2C0CONCLR  = 0x6C;										// Reset all I2C Status  
  I2C0CONSET |= 0x40;									    // Enable I2C Interface  
  I2C0CONSET |= 0x20;										// Send Start Condition

  // Wait I2C Status Return
  while((I2C0STAT)!= 0x08){;;}								// Wait Start Condition Complete  
  I2C0DAT    = Addr;										// Send PCF8574A+[Read/Write]
  I2C0CONCLR = 0x28;									    // Clear Start Bit + Interrupt Flag  

  // Wait I2C Status Return
  while((I2C0STAT)!= 0x18){;;}								// Wait Slave Address+W, ACK
  I2C0DAT = Data;											// Send Output Data to PCF8574A
  I2C0CONCLR = 0x0C;										// Clear Acknowledge Bit + Interrupt Flag

  // Wait I2C Status Return
  while((I2C0STAT)!= 0x28){;;}								// Wait Slave Address+W, ACK   
  I2C0CONSET |= 0x10;										// Send Stop Condition
  I2C0CONCLR = 0x0C;										// Clear Acknowledge Bit + Interrupt Flag   
}

/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay_led(unsigned long int count1)
{
  while(count1 > 0) {count1--;}								// Loop Decrease Counter	
}

